/*
Copyright (c) 2009 Stephen John Bush

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#define TRACING 0

//C4530: C++ exception handler used, but unwind semantics are not enabled. 
//#pragma warning (disable: 4530)
#include <iostream>

//#include <stdio.h>
#include <string>

//#include <postgresql/libpq-fe.h>//in postgres/include
#include <libpq-fe.h>//in postgres/include

#include <boost/interprocess/ipc/message_queue.hpp>
#include <boost/bind.hpp>
#include <boost/thread.hpp>
#include <boost/thread/tss.hpp>
#include <boost/thread/mutex.hpp>
#include <boost/thread/condition.hpp>

//using namespace boost::interprocess;

//
//#define MV_NO_NARROW

#include "mv.h"
#include "mvutf.h"
#include "mvenvironment.h"
#include "mvexceptions.h"

DLL_PUBLIC
boost::thread_specific_ptr<int> tss_environmentns;

//#define BUFSIZE 1048576
#define BUFSIZE 262144

//using namespace std;

//for mingw

namespace exodus
{

//defined in MVdbPostgres
extern boost::thread_specific_ptr<PGconn> tss_pgconns;
extern boost::thread_specific_ptr<var> tss_pgconnparams;
extern boost::thread_specific_ptr<bool> tss_ipcstarted;

boost::mutex global_ipcmutex;
boost::condition global_ipccondition;

int getenvironmentn()
{
	if (!tss_environmentns.get())
		return 0;
	return *tss_environmentns.get();
}

inline std::wstring fromutf8(const char* start, const int length)
{
	return wstringfromUTF8((UTF8*)(start), length);
}

void getResponseToRequest(char* chRequest, size_t& request_size,char* chResponse,int& nresponsebytes)
{

	//bytes read from pipe
	//_tprintf( TEXT(L"[%d] %s\n"), pipe->hPipeInst, pipe->chRequest);
	//wprintf(L"MVipc() read  %d bytes -> \"%s\"\n",Pipe[i].cbRead, Pipe[i].chRequest);

	//get a pointer to the beginning of request
	//NB not wchar_t*
	char* prequest=chRequest;

	//get a pointer to integer version of the input pointer (to aid getting integer lengths)
	int** plength;
	plength=(int**)&prequest;

	//get the total length from the first bytes of the request
	//int totlength=int(*prequest);
	int totlength=**plength;
	prequest+=sizeof(int);
	
	var reply=L"NEOSYS_IPC_ERROR: ";

	//check it agrees with the number of bytes read from the pipe and fail if it doesnt
	if (request_size<=0)
	{
		reply=L"";
		#if TRACING >= 2
			wcout<<L"*";
		#endif
	}
	else if (totlength!=request_size)
	{
		reply^=L" Only ";
		reply^=int(request_size);
		reply^=L" bytes read. Should be ";
		reply^=totlength;
		std::wcout<<reply<<std::endl;

	}

	else
	{
		#if TRACING >= 2
			wcout<<L".";
		#endif
		//extract the remainder of the fields in the request

		//filename
		var filename=fromutf8(prequest+sizeof(int),**plength);
		prequest+=*prequest+sizeof(int);

		//dict key
		var dictkey=fromutf8(prequest+sizeof(int),**plength);
		prequest+=*prequest+sizeof(int);

		//record key
		var datakey=fromutf8(prequest+sizeof(int),**plength);
		prequest+=*prequest+sizeof(int);

		//record data
		var data=fromutf8(prequest+sizeof(int),**plength);
		prequest+=*prequest+sizeof(int);

		//valuen
		var valueno=int(**plength);
		prequest+=sizeof(int);

		//subvaluen
		var subvalueno=int(**plength);
		prequest+=sizeof(int);

		#if TRACING >= 3
			wcout<<L"MVipc()";
			wcout<<L"\ntotal bytes:"<<totlength;
			wcout<<L"\nbytes read: "<<request_size;
			wcout<<L"\ndictkey:    "<<dictkey;
			wcout<<L"\ndatakey:    "<<datakey;
			wcout<<L"\ndata:       "<<data;
			wcout<<L"\nvalueno:    "<<valueno;
			wcout<<L"\nsubvalue:   "<<subvalueno<<endl;
		#endif

		//call the relevent dictionary function to calculate the result
/*
		var library;
		if (!library.load(filename))
			throw L"MVCipc() " ^ filename ^ L" unknown filename";
		reply=library.call(filename,dictkey);
*/
		reply="hello";
		//MvEnvironment env;
		//Market dict(&mv);
		//var cell=dict(dictid);
//		reply=data.extract(1);
		//if (reply.substr(1,1)==L"A") reply=L"";
	}

	//limit the number of bytes of the reply sent to the buffer size
	//nresponsebytes=int(reply.length())*sizeof(char);
	std::string responsestring=reply.tostring();
	nresponsebytes=int(responsestring.length());
	if (nresponsebytes>BUFSIZE)
	{
		reply=var(L"NEOSYS_IPC_ERROR: Response bytes) " ^ var(nresponsebytes) ^ L" too many for queue buffer bytes " ^ var(BUFSIZE));
		std::string responsestring=reply.tostring();
	}
	//fail safe check again
	if (nresponsebytes>BUFSIZE)
	{
		throw var(L"NEOSYS_IPC_ERROR: Response bytes " ^ var(nresponsebytes) ^ L" too many for queue buffer bytes " ^ var(BUFSIZE));
	}

	//copy the var reply data into the reply buffer
//	memcpy(chResponse,reply.data(),nresponsebytes);
	nresponsebytes=int(responsestring.length());
	memcpy(chResponse,responsestring.data(),nresponsebytes);

	return;

}

void respondToRequests(boost::interprocess::message_queue& request_queue, boost::interprocess::message_queue& response_queue)
{

	std::size_t request_size;
	unsigned int priority;

	char chRequest[BUFSIZE];
	char chResponse[BUFSIZE];

	int nresponsebytes;

	while (true)
	{

		//get a request
		try
		{
			request_queue.receive(&chRequest, BUFSIZE, request_size, priority);
		}

		//handle failure to get a request
		catch(boost::interprocess::interprocess_exception &ex)
		{
			std::cout << "mvipc: failed to receive " << ex.what() << std::endl;
			continue;
		}

		//log
		#if TRACING >= 3
			wprintf(L"---------------------------------\nMVipc() read  %d bytes from pipe\n",request_size);
		#endif
				
		//determine a response
		getResponseToRequest(chRequest,request_size,chResponse,nresponsebytes);

		//send a response
		try
		{
			response_queue.send(chResponse, nresponsebytes, 0);
		}

		//handle failure to send response
		catch(boost::interprocess::interprocess_exception &ex)
		{
			std::cout << "mvipc: failed send " << ex.what() << std::endl;
			continue;
		}

		//log
		#if TRACING >= 3
			wprintf(L"MVipc() wrote %d bytes <- \"\"\n",nresponsebytes);
		#endif

	}
}

void closeipcqueues(const std::string& requestqueuename, const std::string& responsequeuename)
{
	//close the request queue
	try
	{
		boost::interprocess::message_queue::remove(requestqueuename.c_str());
	}
	catch(boost::interprocess::interprocess_exception &ex)
	{
		std::cout << "cannot close " << requestqueuename << " " << ex.what() << std::endl;
	}

	//close the response queue
	try
	{
		boost::interprocess::message_queue::remove(responsequeuename.c_str());
	}
	catch(boost::interprocess::interprocess_exception &ex)
	{
		std::cout << "cannot close " << responsequeuename << " " << ex.what() << std::endl;
	}

}

//this function is started as a thread by startipc()
int MVipc(const int environmentn, var pgconnparams)
{

	//TODO prevent or handle SELECT in dictionary functions

	//flag to connect NOT to be recursive and open yet another ipc thread
	tss_ipcstarted.reset(new bool(true));

	//clone the postgres connection because the parent thread is running a select with it
	if (!var().connect(pgconnparams))
	{
		throw var(L"MVipc Cannot connect additional thread to postgres");
		return false;
	}

	//set the threads environment number (same as and provided by the parent thread)
	//AFTER opening the database connection
	tss_environmentns.reset(new int(environmentn));
	
	//"\\\\.\\pipe\\exoduspipexyz"
	//strings of MS tchars
	//typedef basic_string<TCHAR> tstring;
	//wchar_t* exoduspipename="\\\\.\\pipe\\exoduspipexyz";
	var temp="requestexodusqueue";
	temp^=environmentn;
	std::string requestqueuename=temp.tostring();
	var temp2="responseexodusqueue";
	temp2^=environmentn;
	std::string responsequeuename=temp2.tostring();
	//string requestqueuename="requestexodusqueue";
	//requestqueuename+=environmentn;
	//string responsequeuename="responseexodusqueue";
	//responsequeuename+=environmentn;

	closeipcqueues(requestqueuename, responsequeuename);

	try
	{
		//open request queue
		boost::interprocess::message_queue request_queue
		(
			boost::interprocess::open_or_create	//only create
			,requestqueuename.c_str()	//name
			,100		//max message number
			,BUFSIZ		//max message size
		);

		try
		{
			//open response queue
			boost::interprocess::message_queue response_queue
			(
				boost::interprocess::open_or_create	//only create
				,responsequeuename.c_str()			//name
				,100		//max message number
				,BUFSIZ		//max message size
			);

			//indicate to waiting/paused parent thread that the pipe is open
			//(the pipe is not actually waiting until the next step)
			//scoped so that the scoped_lock is automatically released after the notification
			{
				boost::mutex::scoped_lock lock(global_ipcmutex);
				#if TRACING >= 1
					wcout<<L"MVipc() Notifying that pipe has been opened\n";
				#endif
				//TODO make sure notifies CORRECT parent thread by using an array of ipcmutexes and tss_environmentn
				global_ipccondition.notify_one();
				#if TRACING >= 1
						wcout<<L"MVipc() Notified that pipe has been opened\n";
				#endif
			}

			respondToRequests(request_queue,response_queue);
			
			std::cout << "stopped responding to queue " << requestqueuename<<std::endl;

		}
		catch(boost::interprocess::interprocess_exception &ex)
		{
			global_ipccondition.notify_one();
			std::cout << "cannot open " << responsequeuename << " " << ex.what() << std::endl;
			closeipcqueues(requestqueuename, responsequeuename);
			return 0;
		}

	}
	catch(boost::interprocess::interprocess_exception &ex)
	{
		global_ipccondition.notify_one();
		std::cout << "cannot open " << requestqueuename << " " << ex.what() << std::endl;
		closeipcqueues(requestqueuename, responsequeuename);
		return 0;
	}

	closeipcqueues(requestqueuename, responsequeuename);
	return 1;
}

bool startipc()
{

	//flag that ipc is started in this thread
	tss_ipcstarted.reset(new bool(true));

	//ensure thread's environment number is available or quit
	if (!tss_environmentns.get())
		return false;

	//get thread's mv environment number
	int environmentn=getenvironmentn();

	//start another thread (for this threads environment) to calculate any dictionary items required by the db server backend
	boost::thread thrd1(boost::bind(&MVipc, environmentn, *tss_pgconnparams.get()));

	//wait for the new thread to signal that it is listening for requests before resuming
	boost::mutex::scoped_lock lock(global_ipcmutex);
	//TODO make sure notifies CORRECT thread by using array of ipcmutexes and environmentn
	//TODO put a timeout in case the pipe doesnt open

	#if TRACING > 0
		std::wcout<<L"startipc() Waiting for pipe to be opened\n";
	#endif

	global_ipccondition.wait(lock);

	#if TRACING > 0
		std::wcout<<L"startipc() Waited for pipe to be opened\n";
	#endif

	return true;

}

}//of namespace exodus
