/*
Copyright (c) 2009 Stephen John Bush

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#ifndef _MSC_VER
#define _POSIX_SOURCE
#endif

#ifdef _POSIX_SOURCE
	#include <cstdlib>
	#include <iostream>
	#include <string>
	#include <stdio.h>
	//for backtrace
//	#include <execinfo.h>

#endif
	//for signal
	#include <signal.h>

//C4530: C++ exception handler used, but unwind semantics are not enabled. 
#pragma warning (disable: 4530)

#include "mvimpl.h"
#include "mv.h"

namespace exodus {

//http://www.delorie.com/gnu/docs/glibc/libc_665.html
var backtrace()
{

#ifndef backtrace
	logputln("backtrace() not implemented on windows yet");
	var().abort("");
	return L"";
#else

	var internaladdresses="";

	void *addresses[10];

	int size = ::backtrace(addresses, 10);
	//char **strings = backtrace_symbols(addresses, size);
	//printf("Stack frames: %d\n", size);
	for(int i = 0; i < size; i++)
	{
		//#pragma warning (disable: 4311)
		internaladdresses^=" " ^ var((int)addresses[i]).oconv("MX");
		//printf("%d: %X\n", i, (int)addresses[i]);
		//printf("%s\n", strings[i]);
	}
	//free(strings);

	FILE *fp;
	//int status;
	char path[1024];

	var binaryfilename=_EXECPATH.field(" ",1);
	if (binaryfilename == binaryfilename.convert("/\\:",""))
		binaryfilename="`which " ^ binaryfilename ^ "`";
	var oscmd="addr2line -e " ^ binaryfilename.quote() ^ " " ^ internaladdresses;

	//oscmd.outputln();

	/* Open the command for reading. */
	fp = popen(oscmd.tostring().c_str(), "r");
	if (fp == NULL)
	{
		printf("Failed to run command\n" );
		return L"";
	}

	var returnlines="";

	/* Read the output a line at a time - output it. */
	while (fgets(path, sizeof(path)-1, fp) != NULL)
	{
		//printf("fgets:%s", path);
		var path2=var(path).convert("\x0d\x0a","");//.outputln("path=");
		var filename=path2.field(":",1);//.outputln("filename=");
		var lineno=path2.field(":",2);//.outputln("lineno=");
		if (lineno)		
		{
			var linetext=filename ^ ":" ^ lineno;
			var filetext;
			if (filetext.osread(filename))
			{
				linetext^=": " ^ filetext.field("\x0A",lineno).trimf(" \t");
			}
			//outputln(linetext);
			returnlines^=FM^linetext;
		}
	}

	/* close */
	pclose(fp);
	
	return returnlines.substr(2);
#endif
	
}

void SIGINT_handler (int sig)
{
	//ignore more of this signal
	//var().breakoff()
	//faster/safer
	signal(sig, SIG_IGN);

	//duplicated in init and B
	backtrace().convert(FM,"\n").outputln();

        printf ("\nInterrupted.\n");
	for (;;)
	{

		output("? ");
		var cmd;
		if (! cmd.inputln())
		continue;
		var cmd1=cmd.substr(1,1).ucase();

		if (cmd1 == "G")
			break;

		else if (cmd1=="E")

			var().abort("Aborted. User interrupt");

		else if (cmd1=="B")

			//duplicated in init and B
			backtrace().convert(FM,"\n").outputln();

		else
			outputln("Commands are (G)o, (E)nd, (B)acktrace");
	}

	//stop ignoreing this signal
	//var().breakon()
	//faster/safer
	signal(SIGINT, SIGINT_handler);
}

void var::breakoff() const
{
	//ignore more of this signal
	signal(SIGINT, SIG_IGN);
}

void var::breakon() const
{
	signal(SIGINT,  SIGINT_handler); /* this line will redirect ctrl+c signal*/
}

}//namespace exodus
