#include <exodus.h>

program()
{

	//Demonstrates Pick style database and dynamic array operations in c++ using EXODUS
	//"SELECT BY/WITH coming very shortly 

	backtrace().convert(FM,"\n").outputln();
	
	println("Login to any Postgres database - must be local to use columns defined as exodus functions");
	if (!connect(""))
	{
		println("Could not connect to database");
		stop();
	}


	//Create a temp file and write 1000 records in it one by one
	////////////////////////////////////////////////////////////

	println();
	
	println("Create temp file");
	var testfilename="TESTFILE";
	createfile(testfilename);

	println("Open the file");
	var testfile;
	if (open(testfilename, testfile))
		println("Opened " ^ testfilename);
	else
	{
		println("Cannot open " ^ testfilename);
		stop();
	}

	println("Start transaction. (Required for speed if many writes outside of a select)");
	begin();

	
	println("Create 1000 records");
	var nrecs=1000;
	for (var ii=1;ii<nrecs;ii++)
	{
		print("+");
		write("XYZ" ^ FM ^ "ABC" ^ ii, testfile,ii);
	}
	println();

	println("End transaction");
	end();

	println("Check we can read a record and extract one field from it");
	var record;
	if (read(record, testfile, "123"))
		println(extract(record,2) ^ " <- should be ABC123");
	else
		println("Cant read record 123");


	//Select and then readnext/read all records one by one
	/////////////////////////////////////////////////
	
	println();

	println("Select the file");
	//"OO" style syntax at the moment
	testfilename.select();

	println("Pass through all the records reading them one by one");
	var key;
	//"OO" style syntax at the moment
	while (testfilename.readnext(key))
	{
		print(".");
		if (!read(record,testfilename,key))
			println("Record " ^ key ^ " is missing!");
	}
	println();


	//Select and then use new readnextrecord function to read all records one by one
	////////////////////////////////////////////////////////////////////////////////
	
	println();

	println("Select the file");
	//"OO" style syntax at the moment
	testfilename.selectrecord();

	println("Pass through all the records - using the new readnextrecord function");
	var key2;
	var record2;
	//"OO" style syntax at the moment
	while (testfilename.readnextrecord(key2,record2))
	{
		print(".");
	}
	println();


	//Select and delete all the records one by one
	//////////////////////////////////////////////

	println();

	println("Select the file");
	testfilename.select();

	println("Delete all the records one by one");
	while (testfilename.readnext(key))
	{
		print("-");
		deleterecord(testfile,key);
	}
	println();


	//Delete the temp file
	//////////////////////

	println();

	println("Delete temp file "^quote(testfilename));
	deletefile(testfilename);


	//Pick rules for concatenation and addition
	//////////////////////////////////////////

	println();

	println("The pick : concatenate operator becomes ^ in exodus c++");
	var xx="2";
	println( " '2' + 2 is " ^ xx + 2 );
	println( " '2' ^ 2 is " ^ xx ^ 2 );

	//following will not even compile because the "2" and the 2 are not exodus "var"s
	//var xx="2" ^ 2;
	//print ln("2" ^ 2)
	

	//Dynamic arrays using pick-like function syntax
	////////////////////////////////////////////////

	println();

	println("Test the various dynamic arrays functions (using pick-like functions)");
	var arr1="ABC" ^ FM ^ "20" ^ VM ^ "200";
	var valuen1;
	if (not(locateby("100",arr1,"AR",valuen1,2)))
		arr1=insert(arr1,2,valuen1,0,"100");
	println(arr1 ^ " <- 100 should be inserted between 20 and 200");

	arr1=replace(arr1,3,2,0,"320");
	println(arr1);

	arr1=insert(arr1,3,2,0,"320B");
	println(arr1);

	//pick delete() function renamed to erase() to avoid c++ reserved keyword "delete"
	arr1=erase(arr1,3,2);
	println(arr1);

	println(extract(arr1,3,2) ^ " <- should be '320'");


	// Dynamic arrays using new OO-like syntax
	//////////////////////////////////////////

	println();

	println("Test the various dynamic arrays functions (using new OO-like syntax)");
	var arr2="ABC" ^ FM ^ "20" ^ VM ^ "200";
	var valuen2;
	if (not(arr2.locateby("100","AR",valuen2,2)))
		arr2.inserter(2,valuen2,0,"100");
	print(arr2);
	println(" <- 100 should be inserted between 20 and 200");

	println(arr2.replacer(3,2,0,"320"));

	println(arr2.inserter(3,2,0,"320B"));

	//pick delete() function renamed to erase() to avoid c++ reserved keyword "delete"
	println(arr2.eraser(3,2));

	print(arr2.extract(3,2));
	println(" <- should be '320'");

	println();
	println("Finished.");

}
